/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.HamsterModel;
import com.ninni.spawn.entity.Hamster;
import com.ninni.spawn.entity.variant.HamsterVariant;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HamsterRenderer<E extends Hamster>
extends MobRenderer<E, HamsterModel<E>> {
    public static final ResourceLocation HAMSTER_GOLDEN_LOCATION = new ResourceLocation("spawn", "textures/entity/hamster/golden.png");
    public static final ResourceLocation HAMSTER_ROBOROWSKI_LOCATION = new ResourceLocation("spawn", "textures/entity/hamster/roborowski.png");
    public static final ResourceLocation HAMSTER_RUSSIAN_LOCATION = new ResourceLocation("spawn", "textures/entity/hamster/russian.png");
    public static final ResourceLocation HAMSTER_TURKISH_LOCATION = new ResourceLocation("spawn", "textures/entity/hamster/turkish.png");
    private final HamsterModel<E> normalModel;
    private final HamsterModel<E> standingModel;

    public HamsterRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.4f);
        this.normalModel = this.createModel(ctx, SpawnEntityModelLayers.HAMSTER);
        this.f_115290_ = this.normalModel;
        this.standingModel = this.createModel(ctx, SpawnEntityModelLayers.HAMSTER_STANDING);
    }

    public void render(E mob, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.f_115290_ = ((Hamster)((Object)mob)).isStanding() ? this.standingModel : this.normalModel;
        super.m_7392_(mob, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(Hamster entity) {
        return switch (entity.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case HamsterVariant.GOLDEN -> HAMSTER_GOLDEN_LOCATION;
            case HamsterVariant.ROBOROWSKI -> HAMSTER_ROBOROWSKI_LOCATION;
            case HamsterVariant.RUSSIAN -> HAMSTER_RUSSIAN_LOCATION;
            case HamsterVariant.TURKISH -> HAMSTER_TURKISH_LOCATION;
        };
    }

    public HamsterModel<E> createModel(EntityRendererProvider.Context context, ModelLayerLocation layer) {
        return new HamsterModel(context.m_174023_(layer));
    }
}

